/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWArrayHandler;
import filenet.vw.api.VWException;
import filenet.vw.api.VWLoggingOptionType;
import filenet.vw.api.VWParameter;
import filenet.vw.api.VWQuery;
import filenet.vw.api.VWWorkElement;
import filenet.vw.api.VWWorkObject;
import filenet.vw.server.VWField;
import filenet.vw.server.VWWorkObjectID;
import java.io.Serializable;

public final class VWInstructionElement
extends VWWorkElement
implements Serializable {
    private static final long serialVersionUID = 7524L;
    public static final int MODE_IN = 1;
    public static final int MODE_OUT = 2;
    public static final int MODE_IN_OUT = 3;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-06-15 21:13:01 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_460_Int/2 $";
    }

    protected VWInstructionElement(VWField[] fieldValues, VWWorkObjectID work_object_Id, VWQuery source) {
        super(fieldValues, work_object_Id, source);
    }

    public VWWorkObject fetchWorkObject(boolean lock, boolean overrideLock) throws VWException {
        VWWorkObject resultObject = new VWWorkObject(null, this.workObjectId, this.sourceQuery);
        resultObject.fetchFields(1, lock, overrideLock);
        if (null == resultObject.workObjectId) {
            return null;
        }
        return resultObject;
    }

    public void refresh(boolean lock, boolean overrideLock) throws VWException {
        this.fetchFields(2, lock, overrideLock);
    }

    public void doRefresh(boolean lock, boolean overrideLock) throws VWException {
        this.fetchFields(2, lock, overrideLock);
    }

    public static VWException[] unlockMany(VWInstructionElement[] invs, boolean save, boolean dispatch) throws VWException {
        int saveType = save ? 2 : 0;
        return VWInstructionElement.unlockSave(invs, saveType, false, null, null, null, false, true, dispatch);
    }

    public static VWException[] doUnlockMany(VWInstructionElement[] invs, boolean save, boolean dispatch) throws VWException {
        int saveType = save ? 2 : 0;
        return VWInstructionElement.unlockSave(invs, saveType, false, null, null, null, false, true, dispatch);
    }

    public static VWException[] saveMany(VWInstructionElement[] invs) throws VWException {
        return VWInstructionElement.unlockSave(invs, 2, false, null, null, null, false, false, false);
    }

    public static VWException[] doSaveMany(VWInstructionElement[] invs) throws VWException {
        return VWInstructionElement.unlockSave(invs, 2, false, null, null, null, false, false, false);
    }

    public void unlock(boolean save, boolean dispatch) throws VWException {
        boolean isExceptionMap;
        VWException[] rets = VWInstructionElement.unlockSave(new VWInstructionElement[]{this}, save ? 2 : 0, false, null, (isExceptionMap = this.getIsExceptionMap()) ? this.getExceptionInstructionSheet() : this.getCallMap(), isExceptionMap ? this.getExceptionDescription() : null, isExceptionMap, true, dispatch);
        if (rets != null && rets[0] instanceof VWException) {
            throw rets[0];
        }
    }

    public void setException(String anInstructionSheetName, String aDescription) throws VWException {
        super.setException(anInstructionSheetName, aDescription);
    }

    public String getExceptionInstructionSheet() {
        return super.getExceptionInstructionSheet();
    }

    public String getExceptionDescription() {
        return super.getExceptionDescription();
    }

    public void save() throws VWException {
        VWException[] rets = VWInstructionElement.saveMany(new VWInstructionElement[]{this});
        if (rets != null && rets[0] instanceof VWException) {
            throw rets[0];
        }
    }

    public static VWException[] lockMany(VWInstructionElement[] intrs, boolean overrideLock) throws VWException {
        return VWWorkElement.lockMany(intrs, overrideLock, 2);
    }

    public static VWException[] doLockMany(VWInstructionElement[] intrs, boolean overrideLock) throws VWException {
        return VWWorkElement.lockMany(intrs, overrideLock, 2);
    }

    public void lock(boolean overrideLock) throws VWException {
        super.lock(overrideLock, 2);
    }

    public void doLock(boolean overrideLock) throws VWException {
        super.lock(overrideLock, 2);
    }

    public static VWException[] terminateMany(VWInstructionElement[] elements) throws VWException {
        return VWWorkElement.terminateMany(elements);
    }

    public static VWException[] doTerminateMany(VWInstructionElement[] elements) throws VWException {
        return VWWorkElement.terminateMany(elements);
    }

    public void terminate() throws VWException {
        super.terminate();
    }

    public void doTerminate() throws VWException {
        super.terminate();
    }

    public int fetchLockedStatus() throws VWException {
        return super.fetchLockedStatus();
    }

    public String[] getFieldNames() {
        return super.getFieldNames();
    }

    public Object getFieldValue(String fieldName) throws VWException {
        return super.getFieldValue(fieldName);
    }

    public void setFieldValue(String fieldName, Object fieldValue) throws VWException {
        VWField field = this.getField(fieldName);
        if (field == null) {
            throw new VWException("vw.api.IESetValueFieldNotFound", "setFieldValue:field name not found.");
        }
        if (field.getMode() == 1) {
            throw new VWException("vw.api.IEFieldNotWritable", "setFieldValue:field cannot be modified since it is MODE_IN.");
        }
        super.setFieldValue(fieldName, fieldValue, false);
    }

    public boolean hasFieldName(String fieldName) throws VWException {
        return super.hasFieldName(fieldName);
    }

    public boolean getIsAltered() {
        return super.getIsAltered();
    }

    public boolean hasBeenAltered(String fieldName) throws VWException {
        return super.hasBeenAltered(fieldName);
    }

    public int getFieldMode(String fieldName) throws VWException {
        return super.getFieldMode(fieldName);
    }

    public String getWorkObjectName() throws VWException {
        return super.getWorkObjectName();
    }

    public String getWorkObjectNumber() throws VWException {
        return super.getWorkObjectNumber();
    }

    public String getTag() throws VWException {
        return super.getTag();
    }

    public String getWorkClassName() throws VWException {
        return super.getWorkClassName();
    }

    public String getWorkPerformerClassName() throws VWException {
        return super.getWorkPerformerClassName();
    }

    public String getOperationName() throws VWException {
        return super.getOperationName();
    }

    public void logMessage(int loggingOption, String message) throws VWException {
        if (!VWLoggingOptionType.isUserLoggingOption(loggingOption)) {
            throw new VWException("vw.api.SEInvalidLoggingOptionType", "The logging option is not a valid logging option type.");
        }
        if (this.sourceQuery.queryType == 1) {
            throw new VWException("vw.api.IEInvalidLogMessageCall", "The message was attempted to be logged for an object retrieved from a roster query. The VWInstructionElement.logMessage method cannot be used for rosters. /n Do not use this method on an object created by a roster query.");
        }
        this.sourceQuery.querySource.cmdSession.logMessage(this.sourceQuery.querySource.viewId, loggingOption, message);
    }

    public String toString() {
        String name = null;
        try {
            name = this.getWorkObjectName();
        }
        catch (VWException vWException) {
            // empty catch block
        }
        return name;
    }

    public void doAbort() throws VWException {
        int saveType = 0;
        boolean isExceptionMap = this.getIsExceptionMap();
        VWException[] results = VWInstructionElement.unlockSave(new VWInstructionElement[]{this}, saveType, false, null, isExceptionMap ? this.getExceptionMap() : this.getCallMap(), isExceptionMap ? this.getExceptionDescription() : null, isExceptionMap, true, false);
        if (results != null && results[0] instanceof VWException) {
            throw results[0];
        }
    }

    public void doDispatch() throws VWException {
        int saveType = 2;
        boolean isExceptionMap = this.getIsExceptionMap();
        VWException[] results = VWInstructionElement.unlockSave(new VWInstructionElement[]{this}, saveType, false, null, isExceptionMap ? this.getExceptionMap() : this.getCallMap(), isExceptionMap ? this.getExceptionDescription() : null, isExceptionMap, true, true);
        if (results != null && results[0] instanceof VWException) {
            throw results[0];
        }
    }

    public String getExceptionMap() throws VWException {
        return super.getExceptionInstructionSheet();
    }

    public void doSave(boolean unlock) throws VWException {
        boolean isExceptionMap = this.getIsExceptionMap();
        int saveType = 2;
        VWException[] results = null;
        results = isExceptionMap ? VWInstructionElement.unlockSave(new VWInstructionElement[]{this}, saveType, false, null, unlock ? this.getExceptionMap() : null, unlock ? this.getExceptionDescription() : null, isExceptionMap, unlock, false) : VWInstructionElement.unlockSave(new VWInstructionElement[]{this}, saveType, false, null, unlock ? this.getCallMap() : null, null, isExceptionMap, unlock, false);
        if (results != null && results[0] instanceof VWException) {
            throw results[0];
        }
    }

    public VWParameter[] getParameterDataFields() throws VWException {
        Object[] dataFields = null;
        VWParameter[] parameters = super.getFilteredParameters(false);
        if (parameters != null && parameters.length > 0) {
            VWArrayHandler dFsHandler = new VWArrayHandler();
            int i = parameters.length;
            while (--i >= 0) {
                int fType = parameters[i].getFieldType();
                if (fType == 64 || fType == 32) continue;
                dataFields = (VWParameter[])dFsHandler.addElementToArray(dataFields, parameters[i]);
            }
            dataFields = (VWParameter[])dFsHandler.getElements(dataFields);
            return dataFields;
        }
        return new VWParameter[0];
    }

    public String getWorkFlowNumber() throws VWException {
        return super.getWorkFlowNumber();
    }

    public String getStepName() throws VWException {
        return super.getStepName();
    }

    public int getServerLocation() throws VWException {
        return super.getServerLocation();
    }
}

